﻿ 
#include "LightHelper.fx"
 
cbuffer cbPerFrame
{
	DirectionalLight gDirLights[3];
	float3 gEyePosW;

	float  gFogStart;
	float  gFogRange;
	float4 gFogColor;
};

cbuffer cbPerObject
{
	float4x4 gWorld;
	float4x4 gWorldInvTranspose;
	float4x4 gWorldViewProj;
	float4x4 gTexTransform;
	Material gMaterial;
};

// Danych nienumerycznych nie można zapisywać w obiekcie cbuffer.
Texture2D gDiffuseMap;

SamplerState samAnisotropic
{
	Filter = ANISOTROPIC;
	MaxAnisotropy = 4;

	AddressU = WRAP;
	AddressV = WRAP;
};

struct VertexIn
{
	float3 PosL    : POSITION;
};

struct VertexOut
{
	float3 PosL    : POSITION;
};

// W potoku teselacji shader wierzchołków wykorzystuje się najczęściej do animacji
// pierwotnych siatek przed ich podziałem.
VertexOut VS(VertexIn vin)
{
	VertexOut vout;
	
	vout.PosL = vin.PosL;

	return vout;
}
 
struct PatchTess
{
	float EdgeTess[3] : SV_TessFactor;
	float InsideTess  : SV_InsideTessFactor;
};

// Generate and output per-patch data such as the quad tessellation factors.
// if a tessellation factor for a patch is set to zero, the patch is culled from the rest of the pipeline.
PatchTess ConstantHS(InputPatch<VertexOut, 3> patch, uint patchID : SV_PrimitiveID)
{
	PatchTess pt;
	
	pt.EdgeTess[0] = 6;
	pt.EdgeTess[1] = 12;
	pt.EdgeTess[2] = 3;
	
	pt.InsideTess = 1;
/*
	float3 centerL = 0.25f*(patch[0].PosL + patch[1].PosL + patch[2].PosL);
	float3 centerW = mul(float4(centerL, 1.0f), gWorld).xyz;
	
	float d = distance(centerW, gEyePosW);

	// Teseluj łatę na podstawie odległości od oka, w ten sposób że
	// teselacja wynosi 0, jeśli d >= d1 i 60, jeśli d <= d0. Przedział
	// [d0, d1] określa zakres teselacji.
	
	const float d0 = 20.0f;
	const float d1 = 300.0f;
	float tess = 64.0f*saturate( (d1-d)/(d1-d0) );

	// Teseluj łatę równomiernie.

	pt.EdgeTess[0] = tess;
	pt.EdgeTess[1] = tess;
	pt.EdgeTess[2] = tess;
	pt.EdgeTess[3] = tess;
	
	pt.InsideTess[0] = tess;
	pt.InsideTess[1] = tess;
	*/
	return pt;
}

struct HullOut
{
	float3 PosL : POSITION;
};


// Ta część shadera powłoki jest często wykorzystywana do zmiany bazy współrzędnych.
[domain("tri")]
[partitioning("integer")]
[outputtopology("triangle_cw")]
[outputcontrolpoints(3)]
[patchconstantfunc("ConstantHS")]
[maxtessfactor(64.0f)]
HullOut HS(InputPatch<VertexOut, 3> p, 
           uint i : SV_OutputControlPointID,
           uint patchId : SV_PrimitiveID)
{
	HullOut hout;
	
	hout.PosL = p[i].PosL;
	
	return hout;
}

struct DomainOut
{
	float4 PosH : SV_POSITION;
};

// Shader dziedziny jest wywoływany dla każdego wierzchołka tworzonego przez teselator.  
// Jest to taki shader wierzchołków po teselacji.
[domain("tri")]
DomainOut DS(PatchTess patchTess, 
             float3 baryCoords : SV_DomainLocation, 
             const OutputPatch<HullOut, 3> tri)
{
	DomainOut dout;
	
	float3 p  = baryCoords.x*tri[0].PosL + baryCoords.y*tri[1].PosL + baryCoords.z*tri[2].PosL;
	
	// Mapowanie przemieszczeń
	p.y = 0;// 0.3f*( p.z*sin(p.x) + p.x*cos(p.z) );
	
	dout.PosH = mul(float4(p, 1.0f), gWorldViewProj);
	
	return dout;
}

float4 PS(DomainOut pin) : SV_Target
{
    return float4(0.0f, 0.0f, 0.0f, 1.0f);
}

technique11 Tess
{
    pass P0
    {
        SetVertexShader( CompileShader( vs_5_0, VS() ) );
        SetHullShader( CompileShader( hs_5_0, HS() ) );
        SetDomainShader( CompileShader( ds_5_0, DS() ) );
        SetPixelShader( CompileShader( ps_5_0, PS() ) );
    }
}
